// Generated by CoffeeScript 1.10.0
var ConnectApp, apps, connect, es, fs, http, http2, https, liveReload, lr, path, tiny_lr, util;

path = require("path");

es = require("event-stream");

util = require("gulp-util");

http = require("http");

https = require("https");

fs = require("fs");

connect = require("connect");

liveReload = require("connect-livereload");

tiny_lr = require("tiny-lr");

lr = void 0;

apps = [];

http2 = void 0;

try {
  http2 = require('http2');
} catch (undefined) {}

ConnectApp = (function() {
  function ConnectApp(options) {
    this.port = options.port || "8080";
    this.root = options.root || path.dirname(module.parent.id);
    this.host = options.host || "localhost";
    this.debug = options.debug || false;
    this.silent = options.silent || false;
    this.https = options.https || false;
    this.livereload = options.livereload || false;
    this.middleware = options.middleware || void 0;
    this.fallback = options.fallback || void 0;
    if (options.open) {
      this.oldMethod("open");
    }
    this.sockets = [];
    this.app = void 0;
    this.run();
  }

  ConnectApp.prototype.run = function() {
    this.app = connect();
    this.handlers().forEach((function(_this) {
      return function(middleware) {
        if (typeof middleware === "object") {
          return _this.app.use(middleware[0], middleware[1]);
        } else {
          return _this.app.use(middleware);
        }
      };
    })(this));
    this.app.use(connect.directory(typeof this.root === "object" ? this.root[0] : this.root));
    if (this.https) {
      if (typeof this.https === 'boolean' || !this.https.key) {
        if (!(typeof this.https === "object")) {
          this.https = {};
        }
        this.https.key = fs.readFileSync(__dirname + '/certs/server.key');
        this.https.cert = fs.readFileSync(__dirname + '/certs/server.crt');
        this.https.ca = fs.readFileSync(__dirname + '/certs/server.crt');
        this.https.passphrase = 'gulp';
      }
      this.server = (http2 || https).createServer(this.https, this.app);
    } else {
      this.server = http.createServer(this.app);
    }
    return this.server.listen(this.port, (function(_this) {
      return function(err) {
        var sockets, stopServer, stoped;
        if (err) {
          return _this.log("Error on starting server: " + err);
        } else {
          _this.log("Server started http" + (_this.https ? 's' : '') + "://" + _this.host + ":" + _this.port);
          stoped = false;
          sockets = [];
          _this.server.on("close", function() {
            if (!stoped) {
              stoped = true;
              return _this.log("Server stopped");
            }
          });
          _this.server.on("connection", function(socket) {
            _this.logDebug("Received incoming connection from " + (socket.address().address));
            _this.sockets.push(socket);
            return socket.on("close", function() {
              return _this.sockets.splice(_this.sockets.indexOf(socket), 1);
            });
          });
          _this.server.on("request", function(request, response) {
            return _this.logDebug("Received request " + request.method + " " + request.url);
          });
          _this.server.on("error", function(err) {
            return _this.log(err.toString());
          });
          stopServer = function() {
            if (!stoped) {
              _this.sockets.forEach(function(socket) {
                return socket.destroy();
              });
              _this.server.close();
              return process.nextTick(function() {
                return process.exit(0);
              });
            }
          };
          process.on("SIGINT", stopServer);
          process.on("exit", stopServer);
          if (_this.livereload) {
            tiny_lr.Server.prototype.error = function() {};
            if (_this.https) {
              lr = tiny_lr({
                key: _this.https.key || fs.readFileSync(__dirname + '/certs/server.key'),
                cert: _this.https.cert || fs.readFileSync(__dirname + '/certs/server.crt')
              });
            } else {
              lr = tiny_lr();
            }
            lr.listen(_this.livereload.port);
            return _this.log("LiveReload started on port " + _this.livereload.port);
          }
        }
      };
    })(this));
  };

  ConnectApp.prototype.handlers = function() {
    var steps;
    steps = this.middleware ? this.middleware.call(this, connect, this) : [];
    if (this.livereload) {
      if (typeof this.livereload === "boolean") {
        this.livereload = {};
      }
      if (!this.livereload.port) {
        this.livereload.port = 35729;
      }
      steps.unshift(liveReload(this.livereload));
    }
    if (typeof this.root === "object") {
      this.root.forEach(function(path) {
        return steps.push(connect["static"](path));
      });
    } else {
      steps.push(connect["static"](this.root));
    }
    if (this.fallback) {
      steps.push((function(_this) {
        return function(req, res) {
          return require('fs').createReadStream(_this.fallback).pipe(res);
        };
      })(this));
    }
    return steps;
  };

  ConnectApp.prototype.log = function(text) {
    if (!this.silent) {
      return util.log(util.colors.green(text));
    }
  };

  ConnectApp.prototype.logWarning = function(text) {
    if (!this.silent) {
      return util.log(util.colors.yellow(text));
    }
  };

  ConnectApp.prototype.logDebug = function(text) {
    if (this.debug) {
      return util.log(util.colors.blue(text));
    }
  };

  ConnectApp.prototype.oldMethod = function(type) {
    var text;
    text = 'does not work in gulp-connect v 2.*. Please read "readme" https://github.com/AveVlad/gulp-connect';
    switch (type) {
      case "open":
        return this.logWarning("Option open " + text);
    }
  };

  return ConnectApp;

})();

module.exports = {
  server: function(options) {
    var app;
    if (options == null) {
      options = {};
    }
    app = new ConnectApp(options);
    apps.push(app);
    return app;
  },
  reload: function() {
    return es.map(function(file, callback) {
      apps.forEach((function(_this) {
        return function(app) {
          if (app.livereload && typeof lr === "object") {
            return lr.changed({
              body: {
                files: file.path
              }
            });
          }
        };
      })(this));
      return callback(null, file);
    });
  },
  lr: lr,
  serverClose: function() {
    apps.forEach(function(app) {
      return app.server.close();
    });
    return apps = [];
  }
};
