<?php
session_start();

include('assets/includes/db.php');

if (!isset($_SESSION['loggedin']) && $_SESSION['loggedin'] != true) {
    header("location: logout.php");
}

if (isset($_POST['add_config'])) {
    $sql = "INSERT INTO ovpn_config (";
    $sql .= "vpn_country, ";
    $sql .= "vpn_location, ";
    $sql .= "vpn_config, ";
    $sql .= "vpn_status, ";
    $sql .= "vpn_type, ";
    $sql .= "auth_type, ";
    $sql .= "auth_embedded) ";
    $sql .= "VALUES (";
    $sql .= "'" . $_POST['add-country'] . "', ";
    $sql .= "'" . $_POST['add-location'] . "', ";
    $sql .= "'" . $_POST['add-url'] . "', ";
    $sql .= "'" . $_POST['add-status'] . "', ";
    $sql .= "'" . $_POST['add-type'] . "', ";
    $sql .= "'" . $_POST['add-auth-type'] . "', ";
    $sql .= "'" . $_POST['add-auth-embedded'] . "');";
    $sqlite3->exec($sql);

    header("Location: ottrunvpn_ovpn.php");
}

if (isset($_POST['edit_config'])) {
    $sql = "UPDATE ovpn_config SET ";
    $sql .= "vpn_country = '" . $_POST['edit-country'] . "', ";
    $sql .= "vpn_location = '" . $_POST['edit-location'] . "', ";
    $sql .= "vpn_state = '" . $_POST['edit-state'] . "', ";
    $sql .= "vpn_config = '" . $_POST['edit-url'] . "',";
    $sql .= "vpn_status = '" . $_POST['edit-status'] . "',";
    $sql .= "vpn_type = '" . $_POST['edit-type'] . "',";
    $sql .= "auth_type = '" . $_POST['edit-auth-type'] . "',";
    $sql .= "auth_embedded = '" . $_POST['edit-auth-embedded'] . "' ";
    $sql .= "WHERE id = " . $_POST['edit-id'] . ";";
    $sqlite3->exec($sql);

    header("Location: ottrunvpn_ovpn.php");
}

if (isset($_GET['disable_config'])) {
    $sql = "UPDATE ovpn_config SET ";
    $sql .= "vpn_status = 'INACTIVE' ";
    $sql .= "WHERE id = " . $_GET['disable_config'] . ";";
    $sqlite3->exec($sql);

    header("Location: ottrunvpn_ovpn.php");
}

if (isset($_GET['enable_config'])) {
    $sql = "UPDATE ovpn_config SET ";
    $sql .= "vpn_status = 'ACTIVE' ";
    $sql .= "WHERE id = " . $_GET['enable_config'] . ";";
    $sqlite3->exec($sql);

    header("Location: ottrunvpn_ovpn.php");
}

if (isset($_POST['delete_config'])) {
    $sql = "DELETE FROM ovpn_config ";
    $sql .= "WHERE id = " . $_POST['delete-id'] . ";";
    $sqlite3->exec($sql);

    header("Location: ottrunvpn_ovpn.php");
}

if (isset($_POST['save_ovpn_credentials'])) {
    $sql = "UPDATE ovpn_credentials SET ";
    $sql .= "ovpn_username = '" . $_POST['openvpn-user-name'] . "', ";
    $sql .= "ovpn_password = '" . $_POST['openvpn-password'] . "';";
    $sqlite3->exec($sql);

    header("Location: ottrunvpn_ovpn.php");
}

if (isset($_POST['save_surfshark_credentials'])) {
    $sql = "UPDATE ovpn_credentials SET ";
    $sql .= "surfshark_username = '" . $_POST['surfshark-username'] . "', ";
    $sql .= "surfshark_password = '" . $_POST['surfshark-password'] . "';";
    $sqlite3->exec($sql);

    header("Location: ottrunvpn_ovpn.php");
}

if (isset($_POST['save_ipvanish_credentials'])) {
    $sql = "UPDATE ovpn_credentials SET ";
    $sql .= "ipvanish_username = '" . $_POST['ipvanish-username'] . "', ";
    $sql .= "ipvanish_password = '" . $_POST['ipvanish-password'] . "';";
    $sqlite3->exec($sql);

    header("Location: ottrunvpn_ovpn.php");
}

if (isset($_POST['save_nordvpn_credentials'])) {
    $sql = "UPDATE ovpn_credentials SET ";
    $sql .= "nordvpn_username = '" . $_POST['nordvpn-username'] . "', ";
    $sql .= "nordvpn_password = '" . $_POST['nordvpn-password'] . "';";
    $sqlite3->exec($sql);

    header("Location: ottrunvpn_ovpn.php");
}

if (isset($_POST['update-sorting'])) {
    $sql = "UPDATE ovpn_sorting SET ";
    $sql .= "group_by = '" . $_POST['group-by'] . "', ";
    $sql .= "order_by = '" . $_POST['order'] . "';";
    $sqlite3->exec($sql);

    header("Location: ottrunvpn_ovpn.php");
}

$json_data = json_decode(file_get_contents("./assets/data/country_name.json"), true);
function getNameFromCode($json, $code)
{
    foreach ($json as $country) {
        if ($country['code'] == $code) {
            return $country['name'];
        }
    }
    return false;
}

?>
<!doctype html>
<html lang="en">

<head>

    <?php include('assets/includes/title-meta.php') ?>

    <?php include('assets/includes/head-css.php') ?>

</head>

<body data-sidebar="dark">

    <!-- Loader -->
    <div id="preloader">
        <div id="status">
            <div class="spinner">
                <i class="ri-loader-line spin-icon"></i>
            </div>
        </div>
    </div>

    <div id="layout-wrapper">

        <?php include('assets/includes/topbar.php') ?>

        <?php include('assets/includes/sidebar.php') ?>

        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-flex align-items-center justify-content-between">
                                <h4 class="mb-0">OTTRun VPN</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Applications</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">OTTRun VPN</a></li>
                                        <li class="breadcrumb-item active">OpenVPN Config</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">

                                    <h4 class="card-title">OpenVPN List</h4>
                                    <p class="card-title-desc col-12">
                                        <a data-toggle="modal" data-target="#credentials-modal" class="credentials-button btn-sm btn-secondary"><i class="dripicons-lock-open"></i> Edit Credentials</a> Please ensure to keep your credentials up-to-date.
                                        <a data-toggle="modal" data-target="#add-modal" class="add-button btn-sm btn-secondary float-right"><i class="dripicons-document-new"></i> Add New Config</a>
                                    </p>

                                    <form method="POST">
                                        <div class=row>
                                            <div class="form-group mt-4 col-6">
                                                <label for="group_by">Order-by</label>
                                                <select class="custom-select" id="group-by" name="group-by">
                                                    <option selected="id">id</option>
                                                    <option value="vpn_country">vpn_country</option>
                                                    <option value="von_location">von_location</option>
                                                </select>
                                            </div>
                                            <div class="form-group mt-4 col-6">
                                                <label for="order">Order</label>
                                                <select class="custom-select" id="order" name="order">
                                                    <option selected="ASC">ASC</option>
                                                    <option value="DESC">DESC</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="text-center mt-4">
                                            <button type="submit" name="update-sorting" class="btn-sm btn-primary">Update Sorting Method</button>
                                            <br />Please note you may need to clear application cache to see changes.
                                        </div>
                                    </form>

                                    <br />
                                    <div class="table-responsive">
                                        <table id="datatable-buttons" class="table dt-responsive table-striped table-bordered nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Country</th>
                                                    <th>Location</th>
                                                    <th>Status</th>
                                                    <th>URL</th>
                                                    <th>Type</th>
                                                    <th hidden>Auth Type</th>
                                                    <th hidden>Auth Embedded</th>
                                                    <th></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php while ($row = $ovpn_config->fetchArray()) { ?>

                                                    <tr>
                                                        <td><?php echo $row['id']; ?></td>
                                                        <td><img src="https://flagcdn.com/40x30/<?php if ($row['vpn_country'] == 'UK') echo 'gb';
                                                                                                else echo strtolower($row['vpn_country']); ?>.png">
                                                            <span id="country-code"><?php echo $row['vpn_country']; ?></span>
                                                        </td>
                                                        <td><?php echo $row['vpn_location']; ?></td>
                                                        <td>
                                                            <div class="badge badge-soft-<?php if ($row['vpn_status'] == 'INACTIVE') {
                                                                                                echo 'danger';
                                                                                            } else {
                                                                                                echo 'success';
                                                                                            }  ?> font-size-12">
                                                                <span id="vpn-status"><?php echo $row['vpn_status']; ?></span>
                                                            </div>
                                                        </td>
                                                        <td><?php echo $row['vpn_config']; ?></td>
                                                        <td><?php echo $row['vpn_type']; ?></td>
                                                        <td hidden><span id="vpn-auth-type"><?php echo $row['auth_type']; ?></span></td>
                                                        <td hidden><span id="vpn-auth-embedded"><?php echo $row['auth_embedded']; ?></span></td>
                                                        <td>
                                                            <button type="button" data-toggle="modal" data-target="#edit-modal" class="edit-button btn-sm btn-primary waves-effect waves-light"><i class="dripicons-document-edit"></i></button>
                                                            <button type="button" data-toggle="modal" data-target="#delete-modal" class="delete-button btn-sm btn-danger waves-effect waves-light"><i class="dripicons-trash"></i></button>
                                                            <?php if ($row['vpn_status'] == 'INACTIVE') { ?>
                                                                <button onclick="window.location.href='./ottrunvpn_ovpn.php?enable_config=<?php echo $row['id']; ?>'" class="enable-button btn-sm btn-success waves-effect waves-light"><i class="dripicons-checkmark"></i></button>
                                                            <?php } else { ?>
                                                                <button onclick="window.location.href='./ottrunvpn_ovpn.php?disable_config=<?php echo $row['id']; ?>'" class="disable-button btn-sm btn-danger waves-effect waves-light"><i class="dripicons-cross"></i></button>
                                                            <?php } ?>
                                                        </td>
                                                    </tr>

                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>

                                    <div class="modal fade" id="add-modal" tabindex="-1" role="dialog" aria-labelledby="addModalLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header border-bottom-0">
                                                    <h5 class="modal-title" id="addModalLabel">Add OVPN Config</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span class="text-danger" aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <form method="POST">
                                                    <div class="modal-body">
                                                        <div class="form-group">
                                                            <label for="add-country">Country</label>
                                                            <select class="custom-select" id="add-country" name="add-country">
                                                                <?php include('assets/includes/select-country.php') ?>
                                                            </select>
                                                            <small id="add-country-small" class="form-text text-muted"><em>Country of config.</em></small>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="add-location">Location</label>
                                                            <input type="text" class="form-control" id="add-location" name="add-location" placeholder="Enter location">
                                                            <small id="add-location-small" class="form-text text-muted"><em>Location of config.</em></small>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="add-url">URL</label>
                                                            <input type="text" class="form-control" id="add-url" name="add-url" placeholder="Enter url">
                                                            <small id="add-url-small" class="form-text text-muted"><em>URL of config.</em></small>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="add-status">Status</label>
                                                            <select class="custom-select" id="add-status" name="add-status">
                                                                <option selected="ACTIVE">ACTIVE</option>
                                                                <option value="INACTIVE">INACTIVE</option>
                                                            </select>
                                                            <small id="add-status-small" class="form-text text-muted"><em>Status of config.</em></small>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="add-type">Service</label>
                                                            <select class="custom-select" id="add-type" name="add-type">
                                                                <option selected="Surfshark">Surfshark</option>
                                                                <option value="IPVanish">IPVanish</option>
                                                                <option value="NordVPN">NordVPN</option>
                                                                <option value="OpenVPN">OpenVPN</option>
                                                            </select>
                                                            <small id="add-type-small" class="form-text text-muted"><em>Service of config.</em></small>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="add-auth-type">Auth Type</label>
                                                            <select class="custom-select" id="add-auth-type" name="add-auth-type">
                                                                <option selected="up">up</option>
                                                                <option value="noup">noup</option>
                                                            </select>
                                                            <small id="add-auth-type-small" class="form-text text-muted"><em>Auth type of config. (up - user&pass / noup - no user&pass)</em></small>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="add-auth-embedded">Auth Embedded</label>
                                                            <select class="custom-select" id="add-auth-embedded" name="add-auth-embedded">
                                                                <option selected="NO">NO</option>
                                                                <option value="YES">YES</option>
                                                            </select>
                                                            <small id="add-auth-embedded-small" class="form-text text-muted"><em>Auth embedded in conf?</em></small>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer text-center mt-4">
                                                        <button type="submit" name="add_config" class="btn-sm btn-primary">Submit</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="modal fade" id="edit-modal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header border-bottom-0">
                                                    <h5 class="modal-title" id="editModalLabel">Edit OVPN Config</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span class="text-danger" aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <form method="POST">
                                                    <div class="modal-body">
                                                        <div class="input-group row" hidden>
                                                            <input type="text" class="form-control" id="edit-id" name="edit-id">
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="edit-country">Country</label>
                                                            <select class="custom-select" id="edit-country" name="edit-country">
                                                                <?php include('assets/includes/select-country.php') ?>
                                                            </select>
                                                            <small id="country-select-small" class="form-text text-muted"><em>Country of config.</em></small>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="edit-location">Location</label>
                                                            <input type="text" class="form-control" id="edit-location" name="edit-location" placeholder="Enter location">
                                                            <small id="edit-location-small" class="form-text text-muted"><em>Location of config.</em></small>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="edit-url">URL</label>
                                                            <input type="text" class="form-control" id="edit-url" name="edit-url" placeholder="Enter url">
                                                            <small id="edit-url-small" class="form-text text-muted"><em>URL of config.</em></small>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="edit-status">Status</label>
                                                            <select class="custom-select" id="edit-status" name="edit-status">
                                                                <option selected="ACTIVE">ACTIVE</option>
                                                                <option value="INACTIVE">INACTIVE</option>
                                                            </select>
                                                            <small id="edit-status-small" class="form-text text-muted"><em>Status of config.</em></small>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="edit-type">Service</label>
                                                            <select class="custom-select" id="edit-type" name="edit-type">
                                                                <option selected="Surfshark">Surfshark</option>
                                                                <option value="IPVanish">IPVanish</option>
                                                                <option value="NordVPN">NordVPN</option>
                                                                <option value="OpenVPN">OpenVPN</option>
                                                            </select>
                                                            <small id="edit-type-small" class="form-text text-muted"><em>Service of config.</em></small>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="edit-auth-type">Auth Type</label>
                                                            <select class="custom-select" id="edit-auth-type" name="edit-auth-type">
                                                                <option selected="up">up</option>
                                                                <option value="noup">noup</option>
                                                            </select>
                                                            <small id="edit-auth-type-small" class="form-text text-muted"><em>Auth type of config. (up - user&pass / noup - no user&pass)</em></small>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="edit-auth-embedded">Auth Embedded</label>
                                                            <select class="custom-select" id="edit-auth-embedded" name="edit-auth-embedded">
                                                                <option selected="NO">NO</option>
                                                                <option value="YES">YES</option>
                                                            </select>
                                                            <small id="edit-auth-embedded-small" class="form-text text-muted"><em>Auth embedded in conf?</em></small>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer text-center mt-4">
                                                        <button type="submit" name="edit_config" class="btn-sm btn-primary">Save</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="modal fade" id="delete-modal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header border-bottom-0">
                                                    <h5 class="modal-title" id="deleteModalLabel">Delete OVPN Config</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span class="text-danger" aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <form method="POST">
                                                    <div class="modal-body">
                                                        <div class="form-group" hidden>
                                                            <input type="text" class="form-control" id="delete-id" name="delete-id">
                                                        </div>
                                                        <h3 class="text-center mt-4">Are you sure?</h3>
                                                    </div>
                                                    <div class="modal-footer text-center mt-4">
                                                        <button type="submit" name="delete_config" class="btn-sm btn-danger">Delete</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                    <script>
                                        $(function() {
                                            $(".edit-button").on('click', function() {
                                                var currentRow = $(this).closest("tr");
                                                var id = currentRow.find("td:eq(0)").text();
                                                var country = currentRow.find("#country-code").text();
                                                var location = currentRow.find("td:eq(2)").text();
                                                var status = currentRow.find("#vpn-status").text();
                                                var url = currentRow.find("td:eq(4)").text();
                                                var type = currentRow.find("td:eq(5)").text();
                                                var auth_type = currentRow.find("#vpn-auth-type").text();
                                                var auth_embedded = currentRow.find("#vpn-auth-embedded").text();
                                                $("#edit-id").val(id);
                                                $("#edit-country:selected").prop("selected", false);
                                                $("#edit-country option[value=" + country + "]").prop("selected", true);
                                                $("#edit-location").val(location);
                                                $("#edit-status").val(status);
                                                $("#edit-url").val(url);
                                                $("#edit-type").val(type);
                                                $("#edit-auth-type").val(auth_type);
                                                $("#edit-auth-embedded").val(auth_embedded);
                                            });
                                            $(".enable-button").on('click', function() {
                                                var currentRow = $(this).closest("tr");
                                                var id = currentRow.find("td:eq(0)").text();
                                                $("#enable-id").val(id);
                                            });
                                            $(".disable-button").on('click', function() {
                                                var currentRow = $(this).closest("tr");
                                                var id = currentRow.find("td:eq(0)").text();
                                                $("#disable-id").val(id);
                                            });
                                            $(".delete-button").on('click', function() {
                                                var currentRow = $(this).closest("tr");
                                                var id = currentRow.find("td:eq(0)").text();
                                                $("#delete-id").val(id);
                                            });
                                        });
                                    </script>

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal fade" id="credentials-modal" tabindex="-1" role="dialog" aria-labelledby="credentialsModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header border-bottom-0">
                                    <h5 class="modal-title" id="credentialsModalLabel">Edit Credentials</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span class="text-danger" aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <h4 class="card-title">Credentials</h4>
                                                <p class="card-title-desc">You will need to add the OpenVPN credentials for each
                                                    account you use, for examlple if you use Surfshark OVPN configurations you will
                                                    need to save your Surfshark OVPN credentials.</p>

                                                <!-- Nav tabs -->
                                                <ul class="nav nav-tabs nav-tabs-custom nav-justified" role="tablist">
                                                    <li class="nav-item">
                                                        <a class="nav-link active" data-toggle="tab" href="#custom-ovpn" role="tab">
                                                            <span class="d-block d-sm-none"><i class="ri-shield-user-line"></i></span>
                                                            <span class="d-none d-sm-block">OpenVPN</span>
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" data-toggle="tab" href="#surfshark" role="tab">
                                                            <span class="d-block d-sm-none"><i class="ri-shield-user-line"></i></span>
                                                            <span class="d-none d-sm-block">Surfshark</span>
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" data-toggle="tab" href="#ipvanish" role="tab">
                                                            <span class="d-block d-sm-none"><i class="ri-shield-user-line"></i></span>
                                                            <span class="d-none d-sm-block">IPVanish</span>
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" data-toggle="tab" href="#nordvpn" role="tab">
                                                            <span class="d-block d-sm-none"><i class="ri-shield-user-line"></i></span>
                                                            <span class="d-none d-sm-block">NordVPN</span>
                                                        </a>
                                                    </li>
                                                </ul>

                                                <!-- Tab panes -->

                                                <div class="tab-content p-3 text-muted">
                                                    <div class="tab-pane active" id="custom-ovpn" role="tabpanel">
                                                        <form method="POST">
                                                            <div class="form-group-sm row mt-1">
                                                                <label class="col-md-3 col-form-label" for="openvpn-user-name">Username</label>
                                                                <div class="col-md-9">
                                                                    <input type="text" id="openvpn-user-name" name="openvpn-user-name" class="form-control" placeholder="Enter openvpn username">
                                                                </div>
                                                            </div>
                                                            <div class="form-group-sm row mt-1">
                                                                <label class="col-md-3 col-form-label" for="openvpn-password">Password</label>
                                                                <div class="col-md-9">
                                                                    <input type="password" id="openvpn-password" name="openvpn-password" class="form-control" placeholder="Enter openvpn password">
                                                                </div>
                                                            </div>
                                                            <div class="text-center mt-1">
                                                                <button type="submit" name="save_ovpn_credentials" class="btn-sm btn-primary waves-effect waves-light">Update</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                    <div class="tab-pane" id="surfshark" role="tabpanel">
                                                        <form method="POST">
                                                            <div class="form-group-sm row mt-1">
                                                                <label class="col-md-3 col-form-label" for="surfshark-username">Username</label>
                                                                <div class="col-md-9">
                                                                    <input type="text" id="surfshark-username" name="surfshark-username" class="form-control" placeholder="Enter surfshark username">
                                                                </div>
                                                            </div>
                                                            <div class="form-group-sm row mt-1">
                                                                <label class="col-md-3 col-form-label" for="surfshark-password">Password</label>
                                                                <div class="col-md-9">
                                                                    <input type="password" id="surfshark-password" name="surfshark-password" class="form-control" placeholder="Enter surfshark password">
                                                                </div>
                                                            </div>
                                                            More info <a href="https://my.surfshark.com/vpn/manual-setup/router/openvpn">here</a>
                                                            <div class="text-center mt-1">
                                                                <button type="submit" name="save_surfshark_credentials" class="btn-sm btn-primary waves-effect waves-light">Update</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                    <div class="tab-pane" id="ipvanish" role="tabpanel">
                                                        <form method="POST">
                                                            <div class="form-group-sm row mt-1">
                                                                <label class="col-md-3 col-form-label" for="ipvanish-username">Username</label>
                                                                <div class="col-md-9">
                                                                    <input type="text" id="ipvanish-username" name="ipvanish-username" class="form-control" placeholder="Enter ipvanish username">
                                                                </div>
                                                            </div>
                                                            <div class="form-group-sm row mt-1">
                                                                <label class="col-md-3 col-form-label" for="ipvanish-password">Password</label>
                                                                <div class="col-md-9">
                                                                    <input type="password" id="ipvanish-password" name="ipvanish-password" class="form-control" placeholder="Enter ipvanish password">
                                                                </div>
                                                            </div>
                                                            More info <a href="https://configs.ipvanish.com/configs/">here</a>
                                                            <div class="text-center mt-1">
                                                                <button type="submit" name="save_ipvanish_credentials" class="btn-sm btn-primary waves-effect waves-light">Update</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                    <div class="tab-pane" id="nordvpn" role="tabpanel">
                                                        <form method="POST">
                                                            <div class="form-group-sm row mt-1">
                                                                <label class="col-md-3 col-form-label" for="nordvpn-username">Username</label>
                                                                <div class="col-md-9">
                                                                    <input type="text" id="nordvpn-username" name="nordvpn-username" class="form-control" placeholder="Enter nordvpn username">
                                                                </div>
                                                            </div>
                                                            <div class="form-group-sm row mt-1">
                                                                <label class="col-md-3 col-form-label" for="nordvpn-password">Password</label>
                                                                <div class="col-md-9">
                                                                    <input type="password" id="nordvpn-password" name="nordvpn-password" class="form-control" placeholder="Enter nordvpn password">
                                                                </div>
                                                            </div>
                                                            More info <a href="https://nordvpn.com/servers/tools/">here</a>
                                                            <div class="text-center mt-1">
                                                                <button type="submit" name="save_nordvpn_credentials" class="btn-sm btn-primary waves-effect waves-light">Update</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div> <!-- end col -->
                    </div> <!-- end row -->

                </div>
            </div>

            <?php include('assets/includes/footer.php'); ?>
        </div>

    </div>

    <?php include('assets/includes/right-sidebar.php'); ?>

    <?php include('assets/includes/vendor-scripts.php'); ?>

    <script src="./assets/js/app.js"></script>

</body>

</html>