<?php
session_start();

include('includes/ottrun_db.php');

date_default_timezone_set('UTC');

if (!isset($_SESSION['loggedin']) && $_SESSION['loggedin'] != true) {
    header("location: logpage_login.html");
}

if (isset($_POST['add_customer'])) {
    $sql = "INSERT INTO extra_customers_ottrun (";
    $sql .= "username, ";
    $sql .= "password, ";
    $sql .= "status, ";
    $sql .= "expiry) ";
    $sql .= "VALUES (";
    $sql .= "'" . $_POST['add-username'] . "', ";
    $sql .= "'" . $_POST['add-password'] . "', ";
    $sql .= "'Active',";
    $sql .= "'" . $_POST['add-expiry'] . "');";
    $sqlite3->exec($sql);

    header("Location: panel/ottrunvpn_customers.php");
}

if (isset($_POST['edit_customer'])) {
    $sql = "UPDATE extra_customers_ottrun SET ";
    $sql .= "username = '" . $_POST['edit-username'] . "', ";
    $sql .= "password = '" . $_POST['edit-password'] . "', ";
    $sql .= "status = '" . $_POST['edit-status'] . "',";
    $sql .= "expiry = '" . $_POST['edit-expiry'] . "' ";
    $sql .= "WHERE id = " . $_POST['edit-id'] . ";";
    $sqlite3->exec($sql);

    header("Location: panel/ottrunvpn_customers.php");
}

if (isset($_GET['disable_customer'])) {
    $sql = "UPDATE extra_customers_ottrun SET ";
    $sql .= "status = 'Disabled' ";
    $sql .= "WHERE id = " . $_GET['disable_customer'] . ";";
    $sqlite3->exec($sql);

    header("Location: panel/ottrunvpn_customers.php");
}

if (isset($_GET['enable_customer'])) {
    $sql = "UPDATE extra_customers_ottrun SET ";
    $sql .= "status = 'Active' ";
    $sql .= "WHERE id = " . $_GET['enable_customer'] . ";";
    $sqlite3->exec($sql);

    header("Location: panel/ottrunvpn_customers.php");
}

if (isset($_POST['delete_customer'])) {
    $sql = "DELETE FROM extra_customers_ottrun ";
    $sql .= "WHERE id = " . $_POST['delete-id'] . ";";
    $sqlite3->exec($sql);

    header("Location: panel/ottrunvpn_customers.php");
}
?>
<!doctype html>
<html lang="en">

<body data-sidebar="dark">

    <!-- Loader -->
    <div id="preloader">
        <div id="status">
            <div class="spinner">
                <i class="ri-loader-line spin-icon"></i>
            </div>
        </div>
    </div>

    <div id="layout-wrapper">

        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">

                                    <h4 class="card-title">Extra Customer List</h4>
                                    <p class="card-title-desc">
                                        <a data-toggle="modal" data-target="#add-modal" class="add-button btn-sm btn-secondary float-right"><i class="dripicons-document-new"></i> Add New Customer</a>
                                    </p>

                                    <br />

                                    <div class="table-responsive">
                                        <table id="datatable-buttons" class="table table-striped table-bordered nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Username</th>
                                                    <th>Password</th>
                                                    <th>Status</th>
                                                    <th>Expiration Date</th>
                                                    <th></th>
                                                </tr>
                                            </thead>
                                            <?php while ($row = $customer_ottrun_data->fetchArray()) { ?>
                                                <tr <?php if ($expired = (time() > strtotime($row['expiry']))) {
                                                        echo 'class="table-warning"';
                                                    } else if ($row['status'] == 'Disabled') {
                                                        echo 'class="table-danger"';
                                                    } else {
                                                        echo '';
                                                    } ?>>
                                                    <td><?php echo $row['id']; ?></td>
                                                    <td><?php echo $row['username']; ?></td>
                                                    <td><?php echo $row['password']; ?></td>
                                                    <td>
                                                        <div class="badge badge-soft-<?php if ($row['status'] != 'Active') {
                                                                                            echo 'danger';
                                                                                        } else {
                                                                                            echo 'success';
                                                                                        }  ?> font-size-12"><?php echo $row['status']; ?></div>
                                                    </td>
                                                    <td><?php if ($expired = (time() > strtotime($row['expiry']))) {
                                                            echo '<span class="text-danger">Expired</span>';
                                                        } else {
                                                            echo $row['expiry'];
                                                        } ?></td>
                                                    <td>
                                                        <button type="button" data-toggle="modal" data-target="#edit-modal" class="edit-button btn-sm btn-primary waves-effect waves-light"><i class="dripicons-document-edit"></i></button>
                                                        <button type="button" data-toggle="modal" data-target="#delete-modal" class="delete-button btn-sm btn-danger waves-effect waves-light"><i class="dripicons-trash"></i></button>
                                                        <?php if ($row['status'] == 'Disabled') { ?>
                                                            <button onclick="window.location.href='./ottrunvpn_customers.php?enable_customer=<?php echo $row['id']; ?>'" class="enable-button btn-sm btn-success waves-effect waves-light"><i class="dripicons-checkmark"></i></a>
                                                            <?php } else { ?>
                                                                <button onclick="window.location.href='./ottrunvpn_customers.php?disable_customer=<?php echo $row['id']; ?>'" class="disable-button btn-sm btn-danger waves-effect waves-light"><i class="dripicons-cross"></i></a>
                                                                <?php } ?>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </table>
                                    </div>

                                    <div class="modal fade" id="add-modal" tabindex="-1" role="dialog" aria-labelledby="addModalLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header border-bottom-0">
                                                    <h5 class="modal-title" id="addModalLabel">Add Customer</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span class="text-danger" aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <form method="POST">
                                                    <div class="modal-body">
                                                        <div class="form-group">
                                                            <label for="add-username">Userame</label>
                                                            <input type="text" class="form-control" id="add-username" name="add-username" placeholder="Enter username">
                                                            <small id="add-username-small" class="form-text text-muted"><em>Username for
                                                                    login.</em></small>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="add-password">Password</label>
                                                            <input type="text" class="form-control" id="add-password" name="add-password" placeholder="Enter password">
                                                            <small id="add-password-small" class="form-text text-muted"><em>Password for login.</em></small>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="add-expiry">Expiry</label>
                                                            <input type="date" class="form-control" id="add-expiry" name="add-expiry" value="<?php echo date("Y-m-d"); ?>">
                                                            <small id="add-expiry-small" class="form-text text-muted"><em>Expiry of customer.</em></small>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="add-status">Status</label>
                                                            <select class="custom-select" id="add-status" name="add-status">
                                                                <option selected="Active">Active</option>
                                                                <option value="Disabled">Disabled</option>
                                                            </select>
                                                            <small id="add-status-small" class="form-text text-muted"><em>Status of customer.</em></small>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer text-center mt-4">
                                                        <button type="submit" name="add_customer" class="btn-sm btn-primary">Submit</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="modal fade" id="edit-modal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header border-bottom-0">
                                                    <h5 class="modal-title" id="editModalLabel">Edit Customer</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span class="text-danger" aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <form method="POST">
                                                    <div class="modal-body">
                                                        <div class="input-group row" hidden>
                                                            <input type="text" class="form-control" id="edit-id" name="edit-id">
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="edit-username">Username</label>
                                                            <input type="text" class="form-control" id="edit-username" name="edit-username" placeholder="Enter username">
                                                            <small id="edit-username-small" class="form-text text-muted"><em>Username for
                                                                    login.</em></small>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="edit-password">Password</label>
                                                            <input type="text" class="form-control" id="edit-password" name="edit-password" placeholder="Enter password">
                                                            <small id="edit-password-small" class="form-text text-muted"><em>Password for login.</em></small>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="edit-expiry">Expiry</label>
                                                            <input type="date" class="form-control" id="edit-expiry" name="edit-expiry" placeholder="Enter expiry">
                                                            <small id="edit-expiry-small" class="form-text text-muted"><em>Expiry of customer.</em></small>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="edit-status">Status</label>
                                                            <select class="custom-select" id="edit-status" name="edit-status">
                                                                <option selected="Active">Active</option>
                                                                <option value="Disabled">Disabled</option>
                                                            </select>
                                                            <small id="edit-status-small" class="form-text text-muted"><em>Status of customer.</em></small>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer text-center mt-4">
                                                        <button type="submit" name="edit_customer" class="btn-sm btn-primary">Save</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="modal fade" id="delete-modal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header border-bottom-0">
                                                    <h5 class="modal-title" id="deleteModalLabel">Delete Customer</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span class="text-danger" aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <form method="POST">
                                                    <div class="modal-body">
                                                        <div class="form-group" hidden>
                                                            <input type="text" class="form-control" id="delete-id" name="delete-id">
                                                        </div>
                                                        <h3 class="text-center mt-4">Are you sure?</h3>
                                                    </div>
                                                    <div class="modal-footer text-center mt-4">
                                                        <button type="submit" name="delete_customer" class="btn-sm btn-danger">Delete</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                    <script>
                                        $(function() {
                                            $(".edit-button").on('click', function() {
                                                var currentRow = $(this).closest("tr");
                                                var id = currentRow.find("td:eq(0)").text();
                                                var username = currentRow.find("td:eq(1)").text();
                                                var password = currentRow.find("td:eq(2)").text();
                                                var status = currentRow.find(".badge").text();
                                                var expiry = currentRow.find("td:eq(4)").text();
                                                $("#edit-id").val(id);
                                                $("#edit-username").val(username);
                                                $("#edit-password").val(password);
                                                $("#edit-status").val(status);
                                                $("#edit-expiry").val(expiry);
                                            });
                                            $(".enable-button").on('click', function() {
                                                var currentRow = $(this).closest("tr");
                                                var id = currentRow.find("td:eq(0)").text();
                                                $("#enable-id").val(id);
                                            });
                                            $(".disable-button").on('click', function() {
                                                var currentRow = $(this).closest("tr");
                                                var id = currentRow.find("td:eq(0)").text();
                                                $("#disable-id").val(id);
                                            });
                                            $(".delete-button").on('click', function() {
                                                var currentRow = $(this).closest("tr");
                                                var id = currentRow.find("td:eq(0)").text();
                                                $("#delete-id").val(id);
                                            });
                                        });
                                    </script>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php include('includes/footer.php'); ?>
        </div>

    </div>

    <?php include('includes/vendor-scripts.php'); ?>

    <script src="./js/app.js"></script>

</body>

</html>